function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 114);

T(1) = (params(2)-1)/params(2);
T(2) = (1-params(11))*exp(T(1)*y(52));
T(3) = exp(y(13))^params(3);
T(4) = exp(y(47));
T(5) = T(4)^(1-params(3));
T(6) = T(3)*T(5);
T(7) = T(6)^T(1);
T(8) = exp(y(44));
T(9) = T(2)*T(7)+params(11)*T(8)^T(1);
T(10) = params(2)/(params(2)-1);
T(11) = 1/params(2);
T(12) = exp(y(45))^T(11);
T(13) = (-1)/params(2);
T(14) = T(8)^T(13);
T(15) = T(12)*exp(T(1)*y(52))*(1-params(11))*(1-params(3));
T(16) = T(6)^T(13);
T(17) = T(4)^(-params(3));
T(18) = T(12)*exp(T(1)*y(52))*(1-params(11))*params(3);
T(19) = exp(y(13))^(params(3)-1);
T(20) = exp(y(46));
T(21) = exp(y(53))*exp(y(32));
T(22) = exp(y(54))*exp(y(31));
T(23) = exp(y(56))*params(6)*exp(params(5)*y(11))*exp(y(7));
T(24) = params(6)*exp(y(55))*exp(params(5)*y(10))*exp(y(6));
T(25) = params(9)^((-1)/params(8));
T(26) = 1/params(8);
T(27) = exp(y(51));
T(28) = exp(y(48))-params(9)*T(4)^(1+params(8))/(1+params(8));
T(29) = T(28)^(-params(14));
T(30) = exp(y(15))-params(9)*exp(y(14))^(1+params(8))/(1+params(8));
T(31) = T(30)^(-params(14));
T(32) = params(13)^(1-params(4));
T(33) = exp(y(113))*params(6)*params(5)*exp(y(115))*exp(y(40)*(params(5)-1));
T(34) = params(12)^(1-params(4));
T(35) = T(29)*exp(y(30))*exp(y(33));
T(36) = params(32)^(-1);
T(37) = T(36)*y(22)*(-(T(27)*exp(y(30))*exp(y(11))));
T(38) = exp(y(30))*y(65)+T(37)+T(36)*y(24)*(-(exp(y(30))*T(27)));
T(39) = T(21)*y(69);
T(40) = exp(y(33))*exp(y(56))*params(6)*exp(y(63))^(params(5)-1);
T(41) = exp(y(30))*exp(y(33))-T(40);
T(42) = params(32)*y(121)*exp(y(35))*params(6)*exp(y(115))*exp(params(5)*y(39));
T(43) = exp(y(35))*y(77)+T(42)+params(32)*y(124)*(-(exp(y(35))*(1-exp(y(39)))))+params(32)*y(128)*(-(exp(y(35))*exp(y(39))));
T(44) = params(32)*y(121)*exp(y(36))*exp(params(5)*y(40))*params(6)*exp(y(116));
T(45) = params(32)*y(127)*(-(exp(y(40))*exp(y(36))));
T(46) = exp(y(36))*y(76)+T(44)+params(32)*y(123)*(-((1-exp(y(40)))*exp(y(36))))+T(45);
T(47) = exp(y(37))*y(79)+y(77)*(-(params(7)*exp(y(37))))+params(32)*y(126)*(-((1-params(7))*exp(y(37))));
T(48) = exp(y(38))*y(78)+y(76)*(-(params(7)*exp(y(38))))+params(32)*y(125)*(-((1-params(7))*exp(y(38))));
T(49) = params(32)*y(121)*exp(y(35))*params(6)*exp(y(115))*params(5)*exp(params(5)*y(39));
T(50) = params(32)*y(128)*(-(exp(y(35))*exp(y(39))))+T(49)+params(32)*y(124)*(-(exp(y(35))*(-exp(y(39)))));
T(51) = exp(y(113))*params(6)*params(5)*exp(y(115))*(params(5)-1)*exp(y(40)*(params(5)-1));
T(52) = y(75)*T(51);
T(53) = (-(exp(y(113))*(exp(y(40))*exp(y(105))+y(106)*(-exp(y(40)))-params(6)*exp(y(115))*params(5)*exp(params(5)*y(40)))));
T(54) = y(72)*T(53);
T(55) = params(32)*y(121)*exp(y(36))*params(6)*exp(y(116))*params(5)*exp(params(5)*y(40));
T(56) = params(32)*y(123)*(-(exp(y(36))*(-exp(y(40)))));
T(57) = T(8)*getPowerDeriv(T(8),T(13),1);
T(58) = T(8)*getPowerDeriv(T(8),T(1),1);
T(59) = getPowerDeriv(T(9),T(10),1);
T(60) = exp(y(45))*getPowerDeriv(exp(y(45)),T(11),1);
T(61) = exp(T(1)*y(52))*(1-params(11))*params(3)*T(60);
T(62) = exp(T(1)*y(52))*(1-params(11))*(1-params(3))*T(60);
T(63) = (1-params(11))*exp(T(1)*y(114));
T(64) = exp(y(110))^(1-params(3));
T(65) = T(20)*getPowerDeriv(T(20),params(3),1);
T(66) = T(20)^params(3);
T(67) = T(64)*T(66);
T(68) = getPowerDeriv(T(67),T(1),1);
T(69) = T(63)*T(64)*T(65)*T(68);
T(70) = T(67)^T(1);
T(71) = T(63)*T(70)+params(11)*exp(y(108))^T(1);
T(72) = getPowerDeriv(T(71),T(10),1);
T(73) = exp(y(110))^(-params(3));
T(74) = exp(y(109))^T(11);
T(75) = T(74)*(1-params(11))*(1-params(3))*exp(T(1)*y(114));
T(76) = T(67)^T(13);
T(77) = getPowerDeriv(T(67),T(13),1);
T(78) = T(64)*T(65)*T(77);
T(79) = T(20)^(params(3)-1);
T(80) = T(74)*(1-params(11))*params(3)*exp(T(1)*y(114));
T(81) = T(20)*getPowerDeriv(T(20),params(3)-1,1);
T(82) = (-(T(64)*(T(79)*T(78)*T(80)+T(76)*T(80)*T(81))));
T(83) = T(4)*getPowerDeriv(T(4),1+params(8),1);
T(84) = (-(params(9)*T(83)/(1+params(8))));
T(85) = getPowerDeriv(T(28),(-params(14)),1);
T(86) = T(84)*T(85);
T(87) = (1-params(3))*exp(y(47)*(1-params(3)));
T(88) = (-(exp(T(1)*y(52))*exp(y(13)*params(3))*T(87)));
T(89) = T(4)*getPowerDeriv(T(4),1-params(3),1);
T(90) = getPowerDeriv(T(6),T(13),1);
T(91) = T(3)*T(89)*T(90);
T(92) = (-(T(16)*T(18)*T(19)*T(89)+T(5)*T(19)*T(18)*T(91)));
T(93) = T(4)*getPowerDeriv(T(4),(-params(3)),1);
T(94) = (-(T(17)*T(3)*T(15)*T(91)+T(3)*T(15)*T(16)*T(93)));
T(95) = getPowerDeriv(T(6),T(1),1);
T(96) = T(2)*T(3)*T(89)*T(95);
T(97) = exp(y(111))-params(9)*exp(y(110))^(1+params(8))/(1+params(8));
T(98) = params(1)*T(97)^(-params(14));
T(99) = exp(y(48))*T(85);
T(100) = (-(params(1)*T(99)/T(31)));
T(101) = T(36)*y(21)*(-(exp(y(49))*T(27)));
T(102) = exp(y(50))*getPowerDeriv(exp(y(50)),T(26),1);
T(103) = (-(T(27)*(exp(y(30))*exp(y(11))+y(42)*(1-exp(y(11)))-exp(params(5)*y(11))*params(6)*exp(y(55)))));
T(104) = T(36)*y(24)*(T(27)*params(6)*params(5)*exp(y(55))*exp(y(11)*(params(5)-1))-T(27)*(exp(y(30))-y(42)))+T(27)*y(71)+T(36)*y(21)*(-(T(27)*(1+exp(y(49))-params(10))))+T(36)*y(22)*T(103)+T(36)*y(23)*(-(y(43)*T(27)*(1-params(7))));
T(105) = T(12)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(52));
T(106) = T(12)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(52));
T(107) = (1-params(11))*T(1)*exp(T(1)*y(52));
T(108) = T(7)*T(107);
T(109) = params(32)^2;
T(110) = T(24)*y(69)+T(36)*y(22)*(-(T(27)*(-(exp(params(5)*y(11))*params(6)*exp(y(55))))))+T(36)*y(24)*T(27)*params(6)*params(5)*exp(y(55))*exp(y(11)*(params(5)-1));
T(111) = exp(y(63))*getPowerDeriv(exp(y(63)),params(5)-1,1);
T(112) = (-(exp(y(33))*exp(y(56))*params(6)*T(111)));
T(113) = T(29)*T(112);
T(114) = T(33)-exp(y(113))*(exp(y(105))-y(106));

end
